/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.blockentity.data;

import com.refinedmods.refinedstorage.RS;
import com.refinedmods.refinedstorage.blockentity.data.BlockEntitySynchronizationParameter;
import com.refinedmods.refinedstorage.blockentity.data.BlockEntitySynchronizationWatcher;
import com.refinedmods.refinedstorage.network.sync.BlockEntitySynchronizationParamaterUpdateMessage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.world.level.block.entity.BlockEntity;

public class BlockEntitySynchronizationManager {
    private static final Map<Integer, BlockEntitySynchronizationParameter> REGISTRY = new HashMap<Integer, BlockEntitySynchronizationParameter>();
    private static int lastId = 0;
    private final BlockEntity blockEntity;
    private final List<BlockEntitySynchronizationParameter> parameters = new ArrayList<BlockEntitySynchronizationParameter>();
    private final List<BlockEntitySynchronizationParameter> watchedParameters = new ArrayList<BlockEntitySynchronizationParameter>();
    private final List<BlockEntitySynchronizationWatcher> watchers = new CopyOnWriteArrayList<BlockEntitySynchronizationWatcher>();

    public BlockEntitySynchronizationManager(BlockEntity blockEntity) {
        this.blockEntity = blockEntity;
    }

    public static void registerParameter(BlockEntitySynchronizationParameter parameter) {
        parameter.setId(lastId);
        REGISTRY.put(lastId++, parameter);
    }

    public static BlockEntitySynchronizationParameter getParameter(int id) {
        return REGISTRY.get(id);
    }

    public static void setParameter(BlockEntitySynchronizationParameter parameter, Object value) {
        RS.NETWORK_HANDLER.sendToServer(new BlockEntitySynchronizationParamaterUpdateMessage(parameter, value));
    }

    public BlockEntity getBlockEntity() {
        return this.blockEntity;
    }

    public void addParameter(BlockEntitySynchronizationParameter parameter) {
        this.parameters.add(parameter);
    }

    public List<BlockEntitySynchronizationParameter> getParameters() {
        return this.parameters;
    }

    public void addWatchedParameter(BlockEntitySynchronizationParameter parameter) {
        this.addParameter(parameter);
        this.watchedParameters.add(parameter);
    }

    public List<BlockEntitySynchronizationParameter> getWatchedParameters() {
        return this.watchedParameters;
    }

    public void addWatcher(BlockEntitySynchronizationWatcher listener) {
        this.watchers.add(listener);
    }

    public void removeWatcher(BlockEntitySynchronizationWatcher listener) {
        this.watchers.remove(listener);
    }

    public void sendParameterToWatchers(BlockEntitySynchronizationParameter parameter) {
        this.watchers.forEach(l -> l.sendParameter(false, parameter));
    }
}

